/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

namespace Unity.FilesLens {

  public class UrlChecker : Object
  {
    /* A string serialized GIcon */
    public string icon { get; private set; }
    
    /* Regexes URLs must match */
    private List<Regex> regexes;
    
    public UrlChecker ()
    {
      icon = new ThemedIcon ("web-browser").to_string ();
      regexes = new List<Regex> ();
      
      try {
        regexes.prepend (new Regex (".+\\...+")); // contains a dot + >= 2 chars
        regexes.prepend (new Regex ("www.*"));
        regexes.prepend (new Regex ("http://.+"));
        regexes.prepend (new Regex ("https://.+"));
      } catch (RegexError e) {
        warning ("Error compiling regular expressions for URL matching. URL launching will not work: %s", e.message);
      }
    }
    
    /* Returns a valid HTTP/HTTPS URL if the input looks like it,
     * or null otherwise */
    public string? check_url (string sample)
    {
      if (sample.strip () == "") return null;

      foreach (var regex in regexes)
      {
        if (regex.match (sample))
          {
            return sample.has_prefix ("http") ? sample : ("http://" + sample);
          }
      }
      
      return null;
    }
    
  } /* end: class UrlChecker */

} /* end: namespace */
